/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouCallbackAddressQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author zhubo
 * @version FuiouCallbackAddressQueryRequest.java, v 0.1 2024-04-02 14:57 zhubo
 */
@Data
public class FuiouCallbackAddressQueryRequest extends FuiouBizRequest<FuiouCallbackAddressQueryResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = 8030275745160791738L;

    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 回调通知类型： 渠道报备通知：report； 整改协查通知：mchtreform 收单审核结果通知：accept
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "notifyType长度不能超过10")
    private String notifyType;
}
