/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.client.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.client.base.VerifySignParam;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;

/**
 * 富友加签默认实现
 *
 * @author liluqing
 * @version DefaultSignerImpl.java, v 0.1 2022-03-02 18:32
 */
@Slf4j
public class DefaultSignerImpl implements ISigner {

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        return doSign(signParam, apiClientConfig);
    }

    @Override
    public Boolean verifySign(Map<String, String> resMap, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        try {
            // 获取待加签字符串
            String waitSignStr = getWaitSignStr(resMap);
            LogUtil.debug(log, "【fuiou-sdk】待验签字符串 >> waitSignStr={}", waitSignStr);
            // 响应签名
            String resSign = resMap.get("sign");
            // 创建加签对象
            Sign sign = new Sign(
                    apiClientConfig.getSignTypeEnum().getAlgorithm(),
                    SecureUtil.decode(apiClientConfig.getFubeiPrivateKey()),
                    SecureUtil.decode(apiClientConfig.getFuiouPublicKey()));

            // 执行加签操作
            return sign.verify(waitSignStr.getBytes(apiClientConfig.getCharset()), Base64.decode(resSign));
        } catch (Exception e) {
            LogUtil.error(log, "【fuiou-sdk】fuiou响应结果验签失败 >> signParam={}", e, verifySignParam);
            throw new FuiouApiException("fuiou响应结果验签失败", e);
        }
    }

    /**
     * 执行方法加签
     *
     * @param signParam
     * @param apiClientConfig
     * @return
     * @throws FuiouApiException
     */
    public String doSign(SignParam signParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        try {
            FuiouBizRequest request = signParam.getRequest();
            // 获取待加签字符串
            Map<String, String> data = FuiouRequestUtils.toMap(request);
            // 获取待加签字符串
            String waitSignStr = getWaitSignStr(data);
            LogUtil.debug(log, "【fuiou-sdk】待加签字符串 >> waitSignStr={}", waitSignStr);
            // 创建加签对象
            Sign sign = new Sign(
                    apiClientConfig.getSignTypeEnum().getAlgorithm(),
                    SecureUtil.decode(apiClientConfig.getFubeiPrivateKey()),
                    null);
            // 执行加签操作
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode(signed);
        } catch (Exception e) {
            LogUtil.error(log, "【fuiou-sdk】fuiou请求加签失败 >> signParam={}", e, signParam);
            throw new FuiouApiException("请求加签失败", e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String algorithm = "MD5WithRSA";
        String privateKey = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAMKz4ubO5o9ZV37dqYEbh30ZjULO\n" +
                "kJIxuIa+P8OhZJKcTX0ue9oAOXjqG5JCShKotEw+YZoVhsjFp+DTscqATIfXucrkkZ/FTLdMP2tg\n" +
                "IZ3seMybJoHtDlG8dzZHZNMu7LbrfXYN7vs7sTQXzCmqGp7qS98kknNdBVqhZ6zO9TPfAgMBAAEC\n" +
                "gYBhqi5FLL/GZEBZaQMfuhlqjSiovEkUrFAtdr0xeoGicTkFdA24OqiZmIUgBpR1a56VKC15RxcH\n" +
                "Gu6s/kOOmnDIS0fakWRLeT70JyFXQA2CC7zvMTzA5SsZpQyZZ219Bgw+g4UO74B1yolSYj1+67hT\n" +
                "CcjlhZxXokSIjFybXY4ccQJBAOTOd6JNp4q9umg1Ig9/8p/k6umAYCVGRAz/gqX3v658cF4653oY\n" +
                "drux/6BoLGtq1wTxYWbWjgyhO44sIjvZrssCQQDZ18u8AW2aRt3RmpESa6vRp7doUvZj3s04jbCD\n" +
                "87MdL+62eUhY4I2adw9e/HCsqjb9Iu0kdxfNXEvsTXhF8Hi9AkAF9ouPo052gzNUe+4DUWZVXHXy\n" +
                "1/GphwdG/3G8OZS5S2zyR764o+KUSbNLzus5cXNhIZlUQMs68QjIT8YkoSu5AkBIoqeP/HnrIw37\n" +
                "Qap1lekoct+4rVDyY+vRm4zrsmpapQzXUwFIgTc19dTuOwXmzKqhJPAlZIBPPSMjm4Eq8M+RAkA5\n" +
                "JP3lE36NOQxcqLzza9UVAzR+sExE0uy9iAxTlxs9NzdxNGPfjkIPYnAVEApR5+s0eCYEC1fuE82g\n" +
                "knHIEE6/";

        Map<String, String> map = new TreeMap<>();
        map.put("name", "111111");
        map.put("age", "222222");
        String waitSignStr = getWaitSignStr(map);
        System.out.println(waitSignStr + "\n\n\n");
        // 创建加签对象
        Sign sign = new Sign(
                algorithm,
                SecureUtil.decode(privateKey),
                null);
        // 执行加签操作
        byte[] signed = sign.sign(waitSignStr.getBytes("GBK"));
        String signStr = Base64.encode(signed);
        System.out.println(signStr);
        map.put("sign", signStr);
        System.out.println("\n\n\n"+ FuiouRequestUtils.generateXml(map));
    }

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, String> dataMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.equals(key, "sign")
                    || StringUtils.startsWith(key, "reserved")) {
                continue;
            }
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(StringUtils.defaultString(value, StringUtils.EMPTY));
        }
        return sb.toString();
    }
}