/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 商户自有子账户创建接口
 *
 * @author
 * @version FuStdCreateSubAccountRes.java, v 0.1 2023-12-28 15:38:48
 */
@Data
public class FuStdCreateSubAccountRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555712679384L;


    /**
     * 交易流水号
     * 
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 自有子账户编号
     * 
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 备注 1
     * 
     * (选填)
     */
    private String remark1;

    /**
     * 备注 2
     * 
     * (选填)
     */
    private String remark2;

}