/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.query;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 记账类交易结果查询接口
 *
 * @author
 * @version FuStdQueryBookTradeReq.java, v 0.1 2024-01-08 19:05:45
 */
@Data
public class FuStdQueryBookTradeReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555507698866L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 交易类型
     * 1 充值记账
2 充值记账撤销
3 转账记账
4 转账记账退回
6 服务费转账
7 商户资金归集
8 订单批量归集
9 订单分账
10 余额分账
11 分账交易退回
12 归集退回
     * (选填)
     */
    @Length(max = 10, message = "tradeType长度不能超过10")
    @NoSign
    private String tradeType;

    /**
     * 富友批次号
     */
    @NoSign
    private String batchNo;

    /**
     * 富友交易参考号
     */
    @NoSign
    private String srcFasSsn;

    /**
     * 源交易商户流水号
     */
    @NoSign
    private String mchntCdTraceNo;

    /**
     * 源交易商户子流水号
     */
    @NoSign
    private String mchntCdChildTraceNo;


    /**
     * 起始日期
     * 起始日期,YYYYMMdd
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "startDate长度不能超过8")
    private String startDate;

    /**
     * 截止日期
     * 截止日期,YYYYMMdd
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "endDate长度不能超过8")
    private String endDate;

    /**
     * 页码
     * 页码
     * (必填)
     */
    @NotNull
    private Integer pageNo;

    /**
     * 分页大小
     * 分页大小
     * (必填)
     */
    @NotNull
    private Integer pageSize;

}