package com.fshows.fuiou.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConvertUtil {

	private static Logger logger = LoggerFactory
			.getLogger(XmlConvertUtil.class);
	// 仍然声明为 ObjectMapper 类型，但用 XmlMapper 实例初始化和配置
	private static final ObjectMapper xmlMapper;

	// 使用静态初始化块来配置 ObjectMapper
	static {
		xmlMapper = new XmlMapper();
		// 配置：在反序列化时忽略未知属性
		xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		// 或者使用更简洁的方法:
		// xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

		// 您还可以在这里添加其他全局配置，例如：
		// 忽略大小写
		// xmlMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
	}

	public static <T> T xml2Bean(String xmlText, Class<T> clazz) throws Exception {
		return xmlMapper.readValue(xmlText, clazz);
	}

	public static <T> String bean2Xml(T bean) throws Exception{
		return xmlMapper.writeValueAsString(bean);
	}

}
