package com.fshows.fuiou.request.merchant; /**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouQuerySignStatusResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouSignStatusQueryRequest.java, v 0.1 2024-11-27 09:50:58
 */
@Data
public class FuiouQuerySignStatusRequest extends FuiouBizRequest<FuiouQuerySignStatusResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555849539181L;

    /**
     * 机构号,接入机构在富友的唯一代码
     */
    @JSONField(name = "ins_cd")
    private String insCd;

    /**
     * 富友商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "traceNo长度不能超过32")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 签约单号
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "contractNo长度不能超过32")
    @JSONField(name = "contract_no")
    private String contractNo;

}