/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.client.impl;

import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.fuiou.util.XmlConvertUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.TreeMap;

/**
 * @author mengqf
 * @version CouponFuiouApiClientImpl.java, v 0.1 2024-08-20 14:00 mengqf
 */
@Slf4j
public class CouponFuiouApiClientImpl extends AbstractFuiouApiClientImpl {

    public CouponFuiouApiClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        super(apiClientConfig);
    }

    public CouponFuiouApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        super(apiClientConfig, httpRequest, signer);
    }
    
    @Override
    protected FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest request, IFuiouApiDefinition couponDefinitionEnum) {
        // 补充参数
        request.setInsCd(apiClientConfig.getAppId());
        // request.setVersion(couponDefinitionEnum.getVersion());
        // request.setRandomStr(IdUtil.simpleUUID());
        return request;
    }

    @Override
    protected SignParam buildSignParam(FuiouBizRequest bizRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        // signParam.setNonceStr(RandomUtil.randomString(12));
        signParam.setRequest(bizRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(FuiouBizRequest fuiouBaseRequest, String sign, IFuiouApiDefinition couponDefinitionEnum) {
        Map<String, String> requstMap = FuiouRequestUtils.toResultMap(fuiouBaseRequest, true);
        requstMap.put("signature", sign);
        requstMap.remove("sign");
        requstMap.remove("version");
        requstMap.remove("randomKey");
        return FuiouRequestUtils.generateXml(requstMap);
    }

    @Override
    protected FuiouBizResponse parseResponse(String body, IFuiouApiDefinition couponDefinitionEnum) throws FuiouApiException {
        try {
            Map<String, String> resMap = XmlConvertUtil.xml2Bean(body, TreeMap.class);
            FuiouBizResponse fuiouBizResponse = FuiouRequestUtils.getObjectFromMap(resMap, couponDefinitionEnum.getResponseClass());
            fuiouBizResponse.setResultCode(resMap.getOrDefault("respCode", "9999"));
            fuiouBizResponse.setResultMsg(resMap.getOrDefault("respDesc", "调用富友异常"));
            fuiouBizResponse.setResultCode("0000".equals(fuiouBizResponse.getResultCode()) ? "000000" : fuiouBizResponse.getResultCode());
            fuiouBizResponse.setResMap(resMap);
            return fuiouBizResponse;
        } catch (Exception e) {
            LogUtil.error(log, "【fuiou-sdk】响应结果反序列化异常 >> resBody={}", e, body);
            throw new FuiouApiException("[fuiou-sdk]响应结果反序列化异常");
        }
    }

    @Override
    public <T extends FuiouBizResponse, R extends IFuiouApiDefinition> T execute(FuiouBizRequest<T, R> request, R couponDefinitionEnum) throws FuiouApiException {
        return (T) super.doExecute(request, couponDefinitionEnum);
    }
}