/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.client.base;

import com.fshows.fuiou.constant.CommonConstant;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 银行卡支付客户端配置信息model
 *
 * @author zhaoxumin
 * @version BankPayApiClientConfig.java, v 0.1 2023-10-13 14:21
 */
@Data
public class BankPayApiClientConfig {

    /**
     * 银行卡支付-富友接口网关根URL
     */
    @NotBlank(message = "银行卡支付-富友api客户端网关根地址不能为空")
    protected String apiParentURL;

    /**
     * 合作方机构号
     */
    @NotBlank(message = "银行卡支付-合作方机构号不能为空")
    protected String relateInsCd;

    /**
     * 签名密钥
     */
    @NotBlank(message = "银行卡支付-签名密钥不能为空")
    protected String signatureKey;

    /**
     * 是否对参数进行前置校验
     */
    protected boolean checkParam = true;

    /**
     * http连接超时时间
     */
    protected int connectionTimeout = CommonConstant.DEFAULT_CONNECTION_TIMEOUT;

    /**
     * http response读取超时时间
     */
    protected int readTimeout = CommonConstant.DEFAULT_READ_TIMEOUT;

    /**
     * 默认编码格式，默认为utf-8
     */
    protected String charset = CommonConstant.UTF_8;
}