/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;


import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 订单批量归集接口
 *
 * @author
 * @version FuStdBatchTradeConcentrateRes.java, v 0.1 2024-01-02 16:31:39
 */
@Data
public class FuStdBatchTradeConcentrateRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555577788556L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 被归集商户号
     * 被归集的商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    private String mchntCdConcentrate;

    /**
     * 被归集金额
     * 分账金额，单位：分
     * (必填)
     */
    @NotNull
    private Integer amt;

    /**
     * 归集类型
     * 01：实时归集
02：受理归集
     * (必填)
     */
    @NotBlank
    private String concentrateType;

    /**
     * 富友批次号
     * 
     * (选填)
     */
    private String batchNo;

}