/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商户账户余额查询接口
 *
 * @author
 * @version FuStdBalanceQueryRes.java, v 0.1 2024-01-02 13:36:38
 */
@Data
public class FuStdBalanceQueryRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555577617628L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 可用金额
     * 
     * (必填)
     */
    @NotNull
    private String availableBalance;

    /**
     * 冻结金额
     * 
     * (必填)
     */
    @NotNull
    private String freezeBalance;

    /**
     * 账面金额
     * 
     * (必填)
     */
    @NotNull
    private String totalBalance;

    /**
     * 待转结金额
     * 
     * (必填)
     */
    @NotNull
    private String waitingCarryBalance;

}