/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 归集授权申请接口
 *
 * @author
 * @version FuStdAddConcentrateRelationReq.java, v 0.1 2023-12-28 15:46:16
 */
@Data
public class FuStdAddConcentrateRelationReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555182501864L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 被归集商户号
     * 被归集商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntCdConcentrate长度不能超过30")
    private String mchntCdConcentrate;

    /**
     * 归集模式列表
     * 归集模式
     *      * 01:余额归集
     *      02:按转结金额归集
     *      03:订单预归集
     *      04:订单事后归集
     */
    private List<String> concentrateTypes;

    /**
     * 订单归集最大比例
     * 如： 100% 传 10000
归集模式为 03 和 04 必填
     * (选填)
     */
    private Integer orderConcentrateScale;

    /**
     * 余额归集最大比例
     * 如： 100% 传 10000
归集模式为 01 和 02 必填
     * (选填)
     */
    private Integer balanceConcentrateScale;

    /**
     * 授权模式
     * 1 短信模式
2 返回 url
不传默认 1
     * (选填)
     */
    @Length(max = 4, message = "checkType长度不能超过4")
    private String checkType;

    /**
     * 授权人手机号
     * 验证类型为短信必填，用来接受签约短信
     * (选填)
     */
    @Length(max = 20, message = "mobile长度不能超过20")
    private String mobile;

    /**
     * 资金用途
     * 01:缴纳品牌费
02:缴纳管理费
03:缴纳服务费
04:资金归集
05:缴纳其他费用
     * (必填)
     */
    @NotBlank
    @Length(max = 4, message = "useType长度不能超过4")
    private String useType;

}