package com.frt.fubeiopenapisdk.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.response.FubeiPayBizResponse;
import com.frt.fubeiopenapisdk.response.trade.detail.FubeiPayOrderQueryPaymentListInfoResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * 付呗订单查询响应参数
 */
@Data
public class FubeiPayOrderQueryResponse extends FubeiPayBizResponse {
    /**
     * 付呗订单号
     */
    @JSONField(name = "order_sn")
    private String orderSn;
    /**
     * 外部系统订单号
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;
    /**
     * 机构订单号（显示在微信/支付宝支付凭证的订单号）
     */
    @JSONField(name = "ins_order_sn")
    private String insOrderSn;
    /**
     * 通道订单号，微信订单号、支付宝订单号等，当支付成功时返回
     */
    @JSONField(name = "channel_order_sn")
    private String channelOrderSn;
    /**
     * 订单状态：
     * USERPAYING--用户支付中
     * SUCCESS--支付成功
     * CLOSED--已关闭
     */
    @JSONField(name = "order_status")
    private String orderStatus;
    /**
     * 支付方式
     * wxpay 微信，alipay 支付宝，unionpay 银联,
     * bankcardpay 银行卡
     * prepay 预付费卡
     */
    @JSONField(name = "pay_type")
    private String payType;
    /**
     * 订单金额，精确到0.01
     */
    @JSONField(name = "total_amount")
    private BigDecimal totalAmount;
    /**
     * 实收金额，精确到0.01，当支付成功时返回
     */
    @JSONField(name = "net_amount")
    private BigDecimal netAmount;
    /**
     * 买家实际支付金额，精确到0.01，当支付成功时返回
     */
    @JSONField(name = "buyer_pay_amount")
    private BigDecimal buyerPayAmount;
    /**
     * 订单支付手续费率
     */
    @JSONField(name = "rate_fee")
    private BigDecimal rateFee;
    /**
     * 手续费（直连订单当日不返回手续费），精确到0.01，当支付成功时返回
     */
    @JSONField(name = "fee")
    private BigDecimal fee;
    /**
     * 商户门店号
     */
    @JSONField(name = "store_id")
    private Integer storeId;
    /**
     * 收银员ID
     */
    @JSONField(name = "cashier_id")
    private Integer cashierId;
    /**
     * 付款用户id,“微信openid”、“支付宝账户”等，当支付成功时返回
     */
    @JSONField(name = "user_id")
    private String userId;
    /**
     * 支付完成时间，格式为yyyyMMddHHmmss，当支付成功时返回
     */
    @JSONField(name = "finish_time")
    private String finishTime;
    /**
     * 终端号
     */
    @JSONField(name = "device_no")
    private String deviceNo;
    /**
     * SAAS合作标识
     */
    @JSONField(name = "channel_tag")
    private String channelTag;
    /**
     * 附加数据，原样返回，该字段主要用于商户携带订单的自定义数据
     */
    @JSONField(name = "attach")
    private String attach;
    /**
     * 活动优惠列表，Json格式。payment_list的值为数组，每一个元素包含两个字段type和amount（元），当支付成功时返回。例子："payment_list": [{"type":"CHANNEL_DISCOUNT","amount": 0.1},{"type": "CHANNEL_PRE","amount": 0.2}]
     */
    @JSONField(name = "payment_list")
    private List<FubeiPayOrderQueryPaymentListInfoResponse> paymentList;
    /**
     * 支付宝业务拓展参数--花呗分期
     */
    @JSONField(name = "alipay_extend_params")
    private FubeiPayOrderQueryPaymentListInfoResponse alipayExtendParams;
    /**
     * 是否支持部分退款, 1 支持 0 不支持
     */
    @JSONField(name = "is_can_part_refund")
    private Integer isCanPartRefund;
    /**
     * 备注
     */
    @JSONField(name = "remark")
    private String remark;

}
