/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.response.FubeiPayBizResponse;
import com.frt.fubeiopenapisdk.response.trade.detail.FubeiPayWxOfficialAccountPaySignResponse;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wangyi
 * @version FubeiPayH5PayOrderResponse.java, v 0.1 2025-09-08 16:35 wangyi
 */
@Data
public class FubeiPayH5PayOrderResponse extends FubeiPayBizResponse {

    /**
     * 第三方订单号
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;

    /**
     * 付呗商户号
     */
    @JSONField(name = "merchant_id")
    private Integer merchantId;

    /**
     * 付呗订单号
     */
    @JSONField(name = "order_sn")
    private String orderSn;

    /**
     * 预支付凭证，微信预支付订单号
     * prepay_id、支付宝交易号等
     */
    @JSONField(name = "prepay_id")
    private String prepayId;

    /**
     * 支付方式
     */
    @JSONField(name = "pay_type")
    private String payType;

    /**
     * 订单金额
     */
    @JSONField(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 商户门店号
     */
    @JSONField(name = "store_id")
    private Integer storeId;

    /**
     * 付款用户id，“微信openid”、“支付宝账户”等
     */
    @JSONField(name = "user_id")
    private String userId;

    /**
     * 附加数据,原样返回
     */
    @JSONField(name = "attach")
    private String attach;

    /**
     * 设备号
     */
    @JSONField(name = "device_no")
    private String deviceNo;

    /**
     * 签名包，当pay_type为wxpay时才返回该字段
     */
    @JSONField(name = "sign_package")
    private FubeiPayWxOfficialAccountPaySignResponse signPackage;

    /**
     * 收银员id
     */
    @JSONField(name = "cashier_id")
    private Integer cashierId;

    /**
     * 银联云闪付支付地址
     */
    @JSONField(name = "union_pay_url")
    private String unionPayUrl;

    /**
     * 二维码原文
     */
    @JSONField(name = "qr_code")
    private String qrCode;
}