/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wangyi
 * @version FubeiPayRemarkConfigResponse.java, v 0.1 2025-10-14 20:53 wangyi
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiPayOrderConfigResponse extends FubeiBizResponse {

    /**
     * 付呗商户号
     */
    private Integer merchantId;
    /**
     * 付呗系统的门店id
     */
    private Integer storeId;
    /**
     * 支付APPID配置结果：1 成功 2 失败
     */
    private Integer subAppidCode;

    /**
     * 支付APPID响应描述
     */
    private String subAppidMsg;

    /**
     * 支付授权目录配置结果：1 成功、2 失败
     */
    private String jsapiCode;

    /**
     * 支付授权目录响应描述
     */
    private String jsapiMsg;
}