/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wangyi
 * @version FubeiPayRemarkConfigResponse.java, v 0.1 2025-10-14 20:53 wangyi
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiPayOrderConfigQueryResponse extends FubeiBizResponse {

    /**
     * 付呗商户号
     */
    private Integer merchantId;
    /**
     * 付呗系统的门店id
     */
    private Integer storeId;

    /**
     * 支付APPID，JsonArray格式
     * {\"appid_config_list\":[{\"sub_appid\":\"null\",\"subscribe_appid\":\"\"},{\"sub_appid\":\"wxba01e33510fcc661\",\"subscribe_appid\":\"wxba01e33510fcc661\"},{\"sub_appid\":\"wx67a851a207854578\",\"subscribe_appid\":\"wx0779a6c2069a92a5\"}]}
     */
    private String appidList;

    /**
     * 支付授权目录列表,JsonArray格式
     * {\"jsapi_path_list\":[\"https://youdian1.test.com/Api/openApiPublicNumberAuth/\",\"https://youdian1.test.com/Wap/Member/\",\"https://youdian1.test.com/Wap/StorePayment/\"]}
     */
    private String jsapiPathList;
}