package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 付呗批量进件
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantRateQueryResponse extends FubeiBizResponse {
    /**
     * 商户号
     */
    private Integer merchantId;

    /**
     * 自定义商户号
     */
    private String merchantCode;

    /**
     * 支付宝分佣率
     * 代理商支付宝分佣率（0-10之间，单位为千分之一）
     */
    private String alipayFeeRate;

    /**
     * 微信分佣率
     * 代理商微信分佣率（0-10之间，单位为千分之一）
     */
    private String wxFeeRateFloat;

    /**
     * 银联分佣率
     * 代理商银联分佣率（3.8-100之间，单位为千分之一）
     */
    private String unionFeeRateFloat;

    /**
     * 商户贷记卡（信用卡）费率
     * 千分之 5.2 ~ 50 保留俩位小数
     */
    private String creditCardFee;
    /**
     * 商户借记卡费率
     * 千分之 4.2 ~ 50 保留俩位小数
     */
    private String debitCardFee;

    /**
     * 商户借记卡封顶手续费（默认18元） 最大不能超过500元
     */
    private String debitCardAppedFee;

    /**
     * 云闪付>1000借记卡费率
     */
    private String union2Fee;

    /**
     * 云闪付>1000借记卡封顶手续费
     */
    private String debitUnion2AppedFee;

    /**
     * 云闪付>1000贷记卡费率
     */
    private String union2CreditFee;

    /**
     * 预付款费率
     * 目前只支持万达的商户
     * 默认 1%  百1 即入参传10
     */
    private String prepayCardFee;

    /**
     * 支付宝云资通商户终端费率（‰），范围：6.1~100
     */
    private String alipayYztRate;

    /**
     * 数币费率
     */
    private String dcepFee;

    /**
     * D0提现费率
     */
    private String d0WithdrawFee;

    /**
     * 支付宝b2b费率
     */
    private String alipayB2bFee;
}
