package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 付呗批量进件
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantEntryResponse extends FubeiBizResponse {

    /**
     * 付呗商户ID
     */
    private Integer merchantId;
    /**
     * 商户账号，外部系统的唯一商户编号（可以用作登录付呗商户后台）
     */
    private String merchantCode;
    /**
     * 付呗门店ID
     */
    private Integer storeId;

    /**
     * 商户APPID
     */
    private String appId;
    /**
     * 商户秘钥
     */
    private String appSecret;
    /**
     * 错误信息
     */
    private String errorMsg;

}
