/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhoujp
 * @version WechatAuthResult.java, v 0.1 2020-12-22 14:59 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantAlipayAuthApplyResponse extends FubeiBizResponse {
    private static final long serialVersionUID = 8354516121592012991L;

    /**
     * 业务申请编号
     */
    private String businessCode;
    /**
     * 服务商申请编号回执
     */
    private String orderNo;
    /**
     * 意愿申请单状态
     * 枚举值：
     * 审核(AUDITING)、
     * 待联系人确认（CONTACT_CONFIRM）
     * 待法人确认（LEGAL_CONFIRM）、
     * 审核通过(AUDIT_PASS)、
     * 审核失败(AUDIT_REJECT)、
     * 已冻结(AUDIT_FREEZE)、
     * 已撤回(CANCELED)
     */
    private String orderStatus;

}