/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.request.FubeiPayBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;

/**
 * @author yangdw
 * @version ScanCardParam.java, v 0.1 2019-11-11 13:53
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiPayScanCardRequest extends FubeiPayBizRequest {

    /**
     * 商户token
     */
    @JSONField(name = "token")
    private String token;

    /**
     * 商户uid
     */
    @JSONField(name = "uid")
    private Integer uid;

    /**
     * agentId 代理商ID.
     */
    @JSONField(name = "agent_id")
    private Integer agentId;

    /**
     * 外部系统订单号
     */
    @NotBlank(message = "不能为空")
    @Size(min = 1, max = 32, message = "长度不合法")
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;

    /**
     * 付呗商户号，以服务商接入必传，商户接入不传
     */
    @JSONField(name = "merchant_id")
    private Integer merchantId;

    /**
     * 支付授权码，用户的付款码
     */
    @NotBlank(message = "不能为空")
    @Size(min = 1, max = 40, message = "长度不合法")
    @JSONField(name = "auth_code")
    private String authCode;

    /**
     * 订单总金额，单位为元
     */
    @NotNull(message = "不能为空")
    @DecimalMax(value = "10000000",message = "订单金额超过上限")
    @DecimalMin(value = "0.01",message = "订单金额低于下限")
    @JSONField(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 订单原始金额
     */
    @JSONField(name = "original_price")
    private BigDecimal originalPrice;

    /**
     * 商户门店号
     */
    @JSONField(name = "store_id")
    private Integer storeId;

    /**
     * 支付公众号appid
     */
    @Size(max = 32, message = "长度不合法")
    @JSONField(name = "sub_appid")
    private String subAppid;

    /**
     * 通道子商户号
     */
    @Size(max = 128, message = "长度不合法")
    @JSONField(name = "sub_mch_id")
    private String subMchId;

    /**
     * 订单优惠标记，代金券或立减优惠功能的参数
     */
    @JSONField(name = "goods_tag")
    private String goodsTag;

    /**
     * 订单包含的商品列表信息，Json格式
     */
    @JSONField(name = "detail")
    private String detail;

    /**
     * 终端号
     */
    @Size(max = 32, message = "长度不合法")
    @JSONField(name = "device_no")
    private String deviceNo;

    /**
     * 商品描述
     */
    @JSONField(name = "body")
    private String body;

    /**
     * 附加数据，原样返回，该字段主要用于商户携带订单的自定义数据
     */
    @Size(max = 128, message = "长度不合法")
    @JSONField(name = "attach")
    private String attach;

    /**
     * 订单失效时间，逾期将关闭交易。
     * <p>
     * 格式为yyyyMMddHHmmss，失效时间需大于1分钟
     */
    @JSONField(name = "timeout_express")
    private String timeoutExpress;

    /**
     * 支付回调地址
     */
    @Length(max = 255,message = "不符合规范")
    @JSONField(name = "notify_url")
    private String notifyUrl;

    /**
     * 新开放平台下单标识
     */
    @JSONField(name = "new_open_api")
    private Integer newOpenApi = 11;

    /**
     * 单品券核销详情
     */
    @JSONField(name = "goods_detail")
    private String goodsDetail;

    /**
     * 支付订单ip
     */
    @JSONField(name = "spbill_create_ip")
    private String spbillCreateIp;

    /**
     * 支付宝支付--花呗分期拓展字段
     */
    @JSONField(name = "alipay_extend_params")
    private String alipayExtendParams;

    /**
     * 收银员id
     */
    @JSONField(name = "cashier_id")
    private Integer cashierId;

    /**
     * 平台方门店号（即微信/支付宝的storeid）
     */
    @JSONField(name = "platform_store_id")
    private String platformStoreId;

    /**
     * 禁用支付渠道(禁用支付宝优惠券、限定不能使用信用卡支付)
     *
     * 支持传多个值，示例：disablePayChannels="promotion,voucher"
     * promotion-支付宝优惠（包含实时优惠+商户优惠）
     * voucher-支付宝营销券
     *
     */
    @JSONField(name = "disable_pay_channels")
    private String disablePayChannels;

    /**
     * 乐刷余额分账自定义打标校验参数
     */
    @JSONField(name = "royalty")
    private Integer royalty;

    /**
     * 备注
     */
    @JSONField(name = "remark")
    private String remark;

    /**
     * SAAS打标-订单中心类型
     */
    @JSONField(name = "channel_tag")
    private String channelTag;
    /**
     * 子商户id
     * 场景：网商云资金场景用到
     */
    @JSONField(name = "account_id")
    private String accountId;

    /**
     * 终端基站信息
     */
    @JSONField(name = "bs_info")
    private String bsInfo;

    /**
     * 交易终端信息
     */
    @JSONField(name = "terminal_info")
    private String terminalInfo;

    /**
     * 设备编号. 针对微信、支付宝有效，透传至银联。
     * 微信：数字、字母、下划线格式
     * 支付宝：目前支持非0开头的数字
     */
    @Size(max = 32, message = "长度不合法")
    @JSONField(name = "device_info")
    private String deviceInfo;
}