/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.request.FubeiPayBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;

/**
 * @author wangyi
 * @version FubeiPayH5PayOrderRequest.java, v 0.1 2025-09-08 16:19 wangyi
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiPayH5PayOrderRequest extends FubeiPayBizRequest {

    /**
     * 商户token
     */
    @JSONField(name = "token")
    private String token;

    /**
     * 商户uid
     */
    @JSONField(name = "uid")
    private Integer uid;

    /**
     * agentId 代理商ID.
     */
    @JSONField(name = "agent_id")
    private Integer agentId;

    /**
     * 外部系统订单号
     */
    @NotBlank(message = "不能为空")
    @Size(min = 1, max = 32, message = "长度不合法")
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;

    /**
     * 付呗商户号，以服务商接入必传，商户接入不传
     */
    @JSONField(name = "merchant_id")
    private Integer merchantId;

    /**
     * 支付方式，微信 wxpay、支付宝 alipay、银联 unionpay
     */
    @NotBlank(message = "不能为空")
    @JSONField(name = "pay_type")
    private String payType;

    /**
     * 订单总金额，单位为元
     */
    @NotNull(message = "不能为空")
    @DecimalMax(value = "10000000",message = "订单金额超过上限")
    @DecimalMin(value = "0.01",message = "订单金额低于下限")
    @JSONField(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 商户门店号
     */
    @JSONField(name = "store_id")
    private Integer storeId;

    /**
     * 支付公众号appid
     */
    @Size(max = 32, message = "长度不合法")
    @JSONField(name = "sub_appid")
    private String subAppid;

    /**
     * 通道子商户号
     */
    @Size(max = 32, message = "长度不合法")
    @JSONField(name = "sub_mch_id")
    private String subMchId;

    /**
     * 用户标识（微信openid，支付宝userid）
     */
    @Size(min = 1, max = 128,message = "长度不合法")
    @JSONField(name = "user_id")
    private String userId;

    /**
     * 订单优惠标记，代金券或立减优惠功能的参数
     */
    @JSONField(name = "goods_tag")
    private String goodsTag;

    /**
     * 订单包含的商品列表信息，Json格式
     */
    @JSONField(name = "detail")
    private String detail;

    /**
     * 终端号
     */
    @Size(min = 1, max = 32,message = "长度不合法")
    @JSONField(name = "device_no")
    private String deviceNo;

    /**
     * 商品描述
     */
    @JSONField(name = "body")
    private String body;

    /**
     * 附加数据，原样返回，该字段主要用于商户携带订单的自定义数据
     */
    @Size(max = 128, message = "长度不合法")
    @JSONField(name = "attach")
    private String attach;

    /**
     * 订单失效时间，逾期将关闭交易。
     * <p>
     * 格式为yyyyMMddHHmmss，失效时间需大于1分钟
     */
    @JSONField(name = "timeout_express")
    private String timeoutExpress;

    /**
     * 支付回调地址
     */
    @Length(max = 255,message = "不符合规范")
    @JSONField(name = "notify_url")
    private String notifyUrl;

    /**
     * 请求IP
     */
    @JSONField(name = "spbill_create_ip")
    private String spbillCreateIp;

    /**
     * 新开放平台下单标识
     */
    @JSONField(name = "new_open_api")
    private Integer newOpenApi = 11;

    /**
     * 支付宝支付--花呗分期拓展字段
     */
    @JSONField(name = "alipay_extend_params")
    private String alipayExtendParams;

    /**
     * 收银员id
     */
    @JSONField(name = "cashier_id")
    private Integer cashierId;

    /**
     * 平台方门店号（即微信/支付宝的storeid）
     */
    @JSONField(name = "platform_store_id")
    private String platformStoreId;
    /**
     * 禁用支付渠道(禁用支付宝优惠券、限定不能使用信用卡支付)
     *
     * 支持传多个值，示例：disablePayChannels="promotion,voucher"
     * promotion-支付宝优惠（包含实时优惠+商户优惠）
     * voucher-支付宝营销券
     *
     */
    @JSONField(name = "disable_pay_channels")
    private String disablePayChannels;

    /**
     * 交易扩展参数
     */
    @JSONField(name = "trade_extend")
    private String tradeExtend;

    /**
     * 支付方式
     * 取值范围：
     * 02 微信公众号/支付宝生活号/银联js支付/支付宝小程序
     * 03 微信小程序
     * 04 通道收银台 目前只支持华夏
     */
    @JSONField(name = "pay_way")
    private String payWay;

    /**
     * 乐刷余额分账自定义打标校验参数
     */
    @JSONField(name = "royalty")
    private Integer royalty;

    /**
     * 备注
     */
    @JSONField(name = "remark")
    private String remark;
    /**
     * SAAS打标-订单中心类型
     */
    @JSONField(name = "channel_tag")
    private String channelTag;

    /**
     * 交易补贴金额
     * ● 单位：元
     * ● 有补贴时必传，不传默认为0
     */
    @JSONField(name = "subsidy_fee")
    private BigDecimal subsidyFee;

    /**
     * sp营销补贴账户，subsidyFee>0时必传
     * 1、购买券商品并且需要广场补贴时传；
     * 2、购买实物商品和普通买单场景时不用传
     */
    @JSONField(name = "subsidy_account")
    private String subsidyAccount;

    /**
     * 单笔消费使用卡券的数量：没有时传0
     */
    @JSONField(name = "coupon_quantity")
    private Integer couponQuantity;

    /**
     * 优惠券列表
     */
    @JSONField(name = "coupon_list")
    private String couponList;

    /**
     * 延迟结算自定义打标参数:0-否；1-是
     * 说明：
     * 1、购券和实物商品（货到付款）的场景需要传；
     * 2、普通买单场景不需要传
     */
    @JSONField(name = "delayed_settle_type")
    private Integer delayedSettleType;

    /**
     * 购买实物商品的商品信息，Json格式。格式见goodsInfo数据格式，scene=WANDA_OUT_GOODS_BUY_SCENE时必传
     */
    @JSONField(name = "goods_info")
    private String goodsInfo;

    /**
     * 用户支付场景
     */
    @JSONField(name = "pay_scene")
    private String payScene;

    /**
     * 订单原始金额
     */
    @JSONField(name = "original_price")
    private BigDecimal originalPrice;

    /**
     * 购券详情
     */
    @JSONField(name = "buy_coupon_detail")
    private String buyCouponDetail;
    /**
     * 子商户id
     * 场景：网商云资金场景用到
     */
    @JSONField(name = "account_id")
    private String accountId;

    /**
     * 设备编号. 针对微信、支付宝有效，透传至银联。
     * 微信：数字、字母、下划线格式
     * 支付宝：目前支持非0开头的数字
     */
    @Size(max = 32, message = "长度不合法")
    @JSONField(name = "device_info")
    private String deviceInfo;

    /**
     * 扫码进入的二维码地址，如码牌地址
     * 合法形式为http/https地址，从2024年二季度开始管控，具体以乐刷发的通知为准
     **/
    @JSONField(name = "qrcode_url")
    private String qrcodeUrl;

    /**
     * 用户前端跳转银联地址返回的用户授权码
     * 用户授权码获取方法见文档 ，从2024年二季度开始管控，具体以乐刷发的通知为准
     **/
    @JSONField(name = "user_authcode")
    private String userAuthcode;

    /**
     * 支付宝产品码
     *      可选值：JSAPI_PAY
     */
    @JSONField(name = "alipay_product_code")
    private String alipayProductCode;

    /**
     * 小程序支付中，商户实际经营主体的小程序应用的appid，也即最终唤起收银台支付所在的小程序的应用id
     * 注意事项
     * 商户需要先在产品管理中心绑定该小程序appid，否则下单会失败
     */
    @JSONField(name = "alipay_op_app_id")
    private String alipayOpAppId;

    /**
     * 万达停车缴费场景，透传分账参数 JSON格式
     */
    @JSONField(name = "sharing_info")
    private String sharingInfo;
}