/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

/**
 * 费率信息
 *
 * @author buhao
 * @version RateInfoBizParam.java, v 0.1 2021-08-10 10:45 buhao
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class RateInfoRequest {
    /**
     * 支付宝商户终端费率（‰），范围：3.8~100。注：若无调整费率权限时勿传，否则会报错
     */
    private String alipayFeeRate;
    /**
     * 微信商户终端费率（‰），范围：3.8~100。注：若无调整费率权限时勿传，否则会报错
     */
    private String wxFeeRate;
    /**
     * 银联商户终端费率（‰），范围：3.8~100。注：若无调整费率权限时勿传，否则会报错
     */
    private String unionFeeRate;
    /**
     * 银联>1000终端费率
     */
    private String union2FeeRate;
    /**
     * 银联>1000借记卡封顶手续费
     */
    private String debitUnion2MaxFeeRate;
    /**
     * 商户贷记卡（信用卡）费率 千分之 5.2 ~ 50 保留俩位小数 和商户借记卡费率，商户借记卡封顶手续费三者同时传值或都不传
     */
    private String creditCardFeeRate;
    /**
     * 商户借记卡费率 千分之 4.2 ~ 50 保留俩位小数
     */
    private String debitCardFeeRate;
    /**
     * 商户借记卡封顶手续费最小18元 最大不能超过500元 封顶手续费只能为整数
     */
    private String debitCardMaxFeeRate;
    /**
     * 云闪付>1000借记卡费率
     */
    private String union2Fee;

    /**
     * 云闪付>1000借记卡封顶手续费
     */
    private String debitUnion2AppedFee;

    /**
     * 云闪付>1000贷记卡费率
     */
    private String union2CreditFee;

    /**
     * 预付款费率
     * 目前只支持万达的商户
     * 默认 1%  百1 即入参传10
     */
    private String prepayCardFee;
    /**
     * 数币费率
     */
    private String dcepFee;
    /**
     * D0提现费率
     */
    private String d0WithdrawRate;
}