/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhubo
 * @version PublicAccountInfoRequest.java, v 0.1 2023-12-05 14:31 zhubo
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class PublicAccountInfoRequest implements Serializable {
    private static final long serialVersionUID = 1508955704653681118L;


    /**
     * 对公户账号
     */
    private String publicSettleAccountNo;
    /**
     * 对公户账户名称
     */
    private String publicSettleAccountName;
    /**
     * 结算银行编号
     */
    private String publicSettleBankCode;
    /**
     * 结算银行名称
     */
    private String publicSettleBankName;

    /**
     * 卡图片
     */
    private String cardPic;

    /**
     * 对公户开户证明
     */
    private String publicSettleOpenPermitPic;
    /**
     * 对公户支行联行号
     */
    private String publicSettleBankBranchCode;
    /**
     * 对公户支行名称
     */
    private String publicSettleBankBranchName;
    /**
     * 对公户支行所在省code
     */
    private String publicSettleBankBranchProvinceCode;
    /**
     * 对公户支行所在省名称
     */
    private String publicSettleBankBranchProvinceName;
    /**
     * 对公户支行所在市code
     */
    private String publicSettleBankBranchCityCode;
    /**
     * 对公户支行所在市名称
     */
    private String publicSettleBankBranchCityName;
    /**
     * 是否手动填写：0否，1手动
     */
    private Integer isHandle;
}
