/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Size;

/**
 * 营业资质信息
 * <p>
 * 注：小微进件不要传此对象
 *
 * @author buhao
 * @version LicenseInfo.java, v 0.1 20210810 14:50 buhao
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class LicenseInfoRequest {

    /**
     * 营业执照注册号(企业，个体户必填)
     */
    @Size(max = 18, message = "营业执照注册号超长")
    private String licenseId;

    /**
     * 营业执照名称，执照如无名称，可填“个体户XXX”（执照上姓名）
     */
    @Size(max = 40, message = "营业执照名称超长")
    private String licenseName;

    /**
     * 营业执照注册地址(企业，个体户必填)
     */
//    @Size(max = 20, message = "营业执照注册地址超长")
    private String licenseAddress;

    /**
     * 营业执照注册号开始日期(企业，个体户必填)格式：2015-09-22
     */
    @Size(max = 32, message = "营业执照注册号开始日期超长")
    private String licenseTimeStart;


    /**
     * 营业执照注册结束日期(企业，个体户必填)格式：2015-09-22，永久有效:长期
     */
    @Size(max = 32, message = "营业执照注册结束日期超长")
    private String licenseTimeEnd;

    /**
     * 营业执照(企业，个体户必填)图片地址
     */
    private String licensePhoto;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
