/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author xujw
 * @version AlipayMerchantAuthLegalInfo.java, v 0.1 2023-01-06 16:42
 */
@Data
public class AlipayMerchantAuthLegalInfo implements Serializable {
    private static final long serialVersionUID = 4035643832200924293L;

    /**
     * 法人姓名 不上传则默认取进件资料
     */
    private String legalName;
    /**
     * 法人证件号码 不上传则默认取进件资料
     */
    private String cardNo;
    /**
     * 法人证件正面照片（人像面）请先使用图片上传上传，上传成功后填写对应的资源id 不上传则默认取进件资料
     */
    private String cardFront;
    /**
     * 法人证件正面照片（国徽面）请先使用图片上传上传，上传成功后填写对应的资源id 当法人证件类型为身份证是必填，其他类型非必填 不上传则默认取进件资料
     */
    private String cardBack;
    /**
     * 请上传证件有效期开始时间 示例值：2019-06-06不上传则默认取进件资料
     */
    private String cardBegin;
    /**
     * 请按照示例值填写，若证件有效期为长期，请填写：长期。示例值：2026-06-06 or 长期不上传则默认取进件资料
     */
    private String cardEnd;
    /**
     * 法人证件有效期是否长期有效0-否1-是 不上传则默认取进件资料
     */
    private Integer cardLong;
    /**
     * 法人证件类型，枚举值：
     * RESIDENT：中国大陆居民-身份证
     * PASSPORT：其他国家或地区居民-护照
     * PASSPORT_HK_MO：中国港澳居民-来往内地通行证
     * PASSPORT_TWN：中国台湾居民-来往大陆通行证
     * RESIDENCE_PERMIT_HM：港澳居民居住证
     * RESIDENCE_PERMIT_TW：台湾居民居住证
     * PERMANENT_RESIDENCE_FOREIGNER：外国人永久居住证
     * 个体户/企业/事业单位/其他组织：可选择任一证件类型，小微商户仅支持身份证类型。
     * 不上传则默认取进件资料
     */
    private String cardType;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}    