/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author xujw
 * @version AlipayMerchantAuthContactInfo.java, v 0.1 2023-01-06 16:40
 */
@Data
public class AlipayMerchantAuthContactInfo implements Serializable {
    private static final long serialVersionUID = 4972738736730452223L;

    /**
     * 联系人姓名
     */
    private String name;
    /**
     * 联系人手机号
     */
    private String mobile;
    /**
     * 联系人身份证号码如联系人无大陆身份证，请走线下拓展码认证
     */
    private String idCardNumber;
    /**
     * 联系人证件类型
     * RESIDENT：中国大陆居民-身份证
     * PASSPORT：其他国家或地区居民-护照
     * PASSPORT_HK_MO：中国港澳居民-来往内地通行证
     * PASSPORT_TWN：中国台湾居民-来往大陆通行证
     * RESIDENCE_PERMIT_HM：港澳居民居住证
     * RESIDENCE_PERMIT_TW：台湾居民居住证
     * PERMANENT_RESIDENCE_FOREIGNER：外国人永久居住证
     * OTHER: 其他
     */
    private String contactCertType;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}    