/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 店铺地址信息
 *
 * @author zhaoyi
 * @version AddressInfo.java, v 0.1 2020-07-27 14:50 zhaoyi
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class AddressInfoRequest implements Serializable {

    private static final long serialVersionUID = -7962599491973616474L;
    /**
     * 商户所在省（填写支付宝地区码）
     */
    @NotBlank(message = "商户所在省不能为空")
    @Size(max = 6, message = "商户所在省超长")
    private String provinceCode;

    /**
     * 市（填写支付宝地区码）
     */
    @NotBlank(message = "商户所在市不能为空")
    @Size(max = 6, message = "商户所在市超长")
    private String cityCode;

    /**
     * 区县（无区县的市传街道编码，东莞、中山）（填写支付宝地区码）
     */
    @NotBlank(message = "商户所在区县不能为空")
    @Size(max = 9, message = "商户所在区县超长")
    private String areaCode;

    /**
     * 商户详细地址(5-40个字符)
     */
    @NotBlank(message = "商户详细地址不能为空")
    @Size(min = 5, max = 40, message = "商户详细地址长度5-40位")
    private String streetAddress;

    /**
     * 门店地址经度
     */
    @NotBlank(message = "门店地址经度不能为空")
    @Pattern(regexp = "[\\-\\+]?(0(\\.\\d{1,10})?|([1-9](\\d)?)(\\.\\d{1,10})?|1[0-7]\\d{1}(\\.\\d{1,10})?|180\\.0{1,10})", message = "格式有误")
    private String longitude;

    /**
     * 门店地址纬度
     */
    @NotBlank(message = "门店地址纬度不能为空")
    @Pattern(regexp = "[\\-\\+]?(0(\\.\\d{1,10})?|([1-9](\\d)?)(\\.\\d{1,10})?|1[0-7]\\d{1}(\\.\\d{1,10})?|180\\.0{1,10})", message = "格式有误")
    private String latitude;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
