/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author wangyi
 * @version FubeiPayRemarkConfigRequest.java, v 0.1 2025-10-14 20:52 wangyi
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiPayOrderConfigRequest extends FubeiBizRequest {

    /**
     * 付呗商户号
     */
    @NotNull(message = "不能为空")
    @Min(value = Integer.MIN_VALUE, message = "不符合规范")
    @Max(value = Integer.MAX_VALUE, message = "不符合规范")
    private Integer merchantId;


    @NotNull(message = "门店id不能为空")
    private Integer storeId;

    /**
     * 支付所使用的公众号appid， 支持使用小程序appid
     */
    private String subAppid;

    /**
     * sub_appid类型
     * 00：公众号（默认）
     * 01：小程序
     */
    private String accountType;

    /**
     * 支付授权目录
     */
    private String jsapiPath;
}