/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author songjian
 * @version WechatApplymentStateParam.java, v 0.1 2020-12-22 14:55 songjian
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantWechatAuthApplyStateQueryRequest extends FubeiBizRequest {
    private static final long serialVersionUID = 7077478610722715882L;
    /**
     * 商户编号
     */
    @NotNull(message = "商户id不能为空")
    private Integer merchantId;
    /**
     * 门店编号
     */
    @NotNull(message = "门店id不能为空")
    private Integer storeId;
    /**
     * 微信子商户号
     */
    @NotBlank(message = "微信子商户号不能为空")
    private String subMchId;
}