package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.AccountInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.AddressInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.BaseInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.ContactInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.LegalPersonRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.LicenseInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.OtherInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.RateInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.ShopInfoRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 付呗批量进件
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantModifyRequest extends FubeiBizRequest {

    /**
     * 商户账号
     */
    @Length(max = 60)
    private String merchantCode;
    /**
     * 商户 ID
     */
    private Integer merchantId;
    /**
     * 商户基本信息
     */
    private BaseInfoRequest baseInfo;

    /**
     * 法人信息，个人类型填联系人信息
     */
    private LegalPersonRequest legalPerson;

    /**
     * 联系人信息
     */
    private ContactInfoRequest contactInfo;

    /**
     * 店铺地址信息
     */
    private AddressInfoRequest addressInfo;

    /**
     * 营业资质信息
     * 小微进件不要传此对象
     */
    private LicenseInfoRequest licenseInfo;

    /**
     * 结算信息
     */
    private AccountInfoRequest accountInfo;

    /**
     * 门店信息
     */
    private ShopInfoRequest shopInfo;

    /**
     * 费率信息
     */
    private RateInfoRequest rateInfo;

    /**
     * 其它信息
     */
    private OtherInfoRequest otherInfo;
}
