package com.frt.fubeiopenapisdk.request.common;

import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 付呗批量进件
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiMerchantImgUploadSecurityRequest extends FubeiBizRequest {

    private static final long serialVersionUID = -7962599491973616474L;

    /**
     * bankCard：银行卡，如：对私银行卡照片、对公开户许可证
     * idCard：身份证，如：个人实名身份证、法人身份证
     * license：营业执照/证明函，如：营业执照、证明函
     * store：门店，如：门店门头照、店内环境照、收银台照片、经营许可证
     * other：其他，如：其他辅助证明
     */
    private String busType;

    /**
     * 图片base64编码，例如："data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAA
     * MCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwY
     * IDAoMDAsKCwsNDhIQDQ4RDgsL"
     */
    private String fileData;
}
