package com.frt.fubeiopenapisdk.apienum;

import com.frt.fubeiopenapisdk.request.common.FubeiMerchantImgUploadSecurityRequest;
import com.frt.fubeiopenapisdk.request.merchant.*;
import com.frt.fubeiopenapisdk.response.common.FubeiMerchantImgUploadSecurityResponse;
import com.frt.fubeiopenapisdk.response.merchant.*;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import lombok.Getter;

@Getter
public enum FubeiMerchantApiDefinitionEnum implements IApiDefinition {

    /**
     * 上传加密图片
     * 接口文档：https://www.yuque.com/51fubei/openapi/merchant_imguploadsecurity
     */
    IMAGE_UPLOAD_SECURITY(
            "上传加密图片",
            "openapi.agent.base.imgupload.security",
            "1.0.0",
            "",
            FubeiMerchantImgUploadSecurityRequest.class,
            FubeiMerchantImgUploadSecurityResponse.class
    ),

    /**
     * 商户批量进件
     * 接口文档：https://www.yuque.com/51fubei/hq1pfy/tkzg5lacad85gd0c
     */
    MERCHANT_BATCH_INCOME(
            "商户批量进件",
            "openapi.new.oem.merchant.income",
            "1.0.0",
            "",
            FubeiMerchantBatchEntryRequest.class,
            FubeiMerchantBatchEntryResponse.class
    ),

    /**
     * 商户入驻
     * 接口文档：https://www.yuque.com/51fubei/openapi/zn4unz
     */
    MERCHANT_INCOME(
            "商户入驻",
            "openapi.merchant.income",
            "1.0.0",
            "",
            FubeiMerchantEntryRequest.class,
            FubeiMerchantEntryResponse.class
    ),

    /**
     * 商户进件状态查询
     * 接口文档：https://fshows.yuque.com/tech-ozd0u/suyx8h/yww37i87nhhvgclm#FxTQ6
     */
    MERCHANT_STATUS_QUERY(
            "商户进件状态查询",
            "openapi.merchant.income.status.query",
            "1.0.0",
            "",
            FubeiMerchantQueryRequest.class,
            FubeiMerchantQueryResponse.class
    ),

    /**
     * 商户协议重新申请接口
     * 接口文档：https://fshows.yuque.com/tech-ozd0u/suyx8h/yww37i87nhhvgclm#FxTQ6
     */
    MERCHANT_OPENAPI_SIGN(
            "商户协议重新申请",
            "openapi.merchant.sign",
            "1.0.0",
            "",
            FubeiMerchantSignRequest.class,
            FubeiMerchantSignResponse.class
    ),

    /**
     * 商户门店状态查询
     * 接口文档：
     */
    MERCHANT_OPENAPI_QUERYSTATUS(
            "商户门店状态查询",
            "openapi.agent.merchant.querystatus",
            "1.0.0",
            "",
            FubeiMerchantQueryStatusRequest.class,
            FubeiMerchantQueryStatusResponse.class
    ),

    /**
     * 商户信息修改
     * 接口文档：https://www.yuque.com/51fubei/openapi/iqi7vw
     */
    MERCHANT_MODIFY(
            "商户信息修改",
            "openapi.merchant.income.modify",
            "1.0.0",
            "",
            FubeiMerchantModifyRequest.class,
            FubeiMerchantModifyResponse.class
    ),

    /**
     * 商户费率修改
     * 接口文档：https://www.yuque.com/51fubei/openapi/merchant_adjustrate
     */
    MERCHANT_RATE(
            "商户费率修改",
            "openapi.agent.merchant.adjustrate",
            "1.0.0",
            "",
            FubeiMerchantRateRequest.class,
            FubeiMerchantRateResponse.class
    ),

    /**
     * 商户费率查询
     */
    MERCHANT_RATE_QUERY(
            "商户费率查询",
            "openapi.agent.merchant.query.rate",
            "1.0.0",
            "",
            FubeiMerchantRateQueryRequest.class,
            FubeiMerchantRateQueryResponse.class
    ),

    /**
     * 打款附言配置
     * 接口文档：https://www.yuque.com/51fubei/openapi/payment_payremarkconfig
     */
    PAY_REMARK_CONFIG(
            "打款附言配置",
            "fbpay.pay.payremark.config",
            "1.0.0",
            "",
            FubeiPayRemarkConfigRequest.class,
            FubeiPayRemarkConfigResponse.class
    ),

    /**
     * 商户权限查询
     */
    MERCHANT_RIGHT_QUERY(
            "商户权限查询",
            "openapi.agent.merchant.right.query",
            "1.0.0",
            "",
            FubeiMerchantRightQueryRequest.class,
            FubeiPayMerchantRightQueryResponse.class
    ),
    WECHAT_AUTH_APPLY(
            "微信实名认证申请",
            "openapi.agent.merchant.wechat.auth.apply",
            "1.0.0",
            "",
            FubeiMerchantWechatAuthApplyRequest.class,
            FubeiMerchantWechatAuthApplyResponse.class
    ),
    WECHAT_AUTH_APPLY_CANNEL(
            "微信实名认证取消",
            "openapi.agent.merchant.wechat.auth.apply.cancel",
            "1.0.0",
            "",
            FubeiMerchantWechatAuthApplyCannelRequest.class,
            FubeiMerchantWechatAuthApplyCancelResponse.class
    ),
    WECHAT_AUTH_APPLY_QUERY(
            "微信实名认证状态查询",
            "openapi.agent.merchant.wechat.auth.apply.query",
            "1.0.0",
            "",
            FubeiMerchantWechatAuthApplyQueryRequest.class,
            FubeiMerchantWechatAuthApplyQueryResponse.class
    ),
    WECHAT_AUTH_APPLY_QUERY_STATE(
            "微信实名认证状态查询",
            "openapi.agent.merchant.wechat.applyment.state",
            "1.0.0",
            "",
            FubeiMerchantWechatAuthApplyStateQueryRequest.class,
            FubeiMerchantWechatAuthApplyStateQueryResponse.class
    ),
    ALIPAY_AUTH_APPLY(
            "支付宝实名认证申请",
            "openapi.agent.merchant.alipay.auth",
            "1.0.0",
            "",
            FubeiMerchantAlipayAuthApplyRequest.class,
            FubeiMerchantAlipayAuthApplyResponse.class
    ),
    ALIPAY_AUTH_APPLY_CANNEL(
            "支付宝实名认证取消",
            "openapi.agent.merchant.alipay.auth.cancel",
            "1.0.0",
            "",
            FubeiMerchantAlipayAuthApplyCannelRequest.class,
            FubeiMerchantAlipayAuthApplyCannelResponse.class
    ),
    ALIPAY_AUTH_APPLY_QUERY(
            "支付宝实名认证状态查询",
            "openapi.agent.merchant.alipay.auth.query",
            "1.0.0",
            "",
            FubeiMerchantAlipayAuthApplyQueryRequest.class,
            FubeiMerchantAlipayAuthApplyQueryResponse.class
    ),


    /**
     * 微信支付参数配置
     * 接口文档：https://www.yuque.com/51fubei/openapi/payment_wxconfig
     */
    FBPAY_ORDER_WXCONFIG(
            "微信支付参数配置",
            "fbpay.order.wxconfig",
            "1.0.0",
            "",
            FubeiPayOrderConfigRequest.class,
            FubeiPayOrderConfigResponse.class
    ),


    /**
     * 微信参数配置查询
     * 接口文档：https://www.yuque.com/51fubei/openapi/payment_wxconfigquery
     */
    FBPAY_ORDER_WXCONFIG_QUERY(
            "微信参数配置查询",
            "fbpay.order.wxconfig.query",
            "1.0.0",
            "",
            FubeiPayOrderConfigQueryRequest.class,
            FubeiPayOrderConfigQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private final String name;

    /**
     * 交易编码
     */
    private final String trancode;

    /**
     * 接口版本
     */
    private final String version;

    /**
     * 接口类型
     */
    private final String interfaceType;

    /**
     * 请求业务参数的Class类型
     */
    private final Class requestClass;

    /**
     * 响应业务参数的Class类型
     */
    private final Class responseClass;

    FubeiMerchantApiDefinitionEnum(String name,
                                   String trancode,
                                   String version,
                                   String interfaceType,
                                   Class requestClass,
                                   Class responseClass) {
        this.name = name;
        this.trancode = trancode;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return trancode;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
