/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.core.client.tempalte.single;

import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.client.component.signer.RsaSignHandlerImpl;
import com.fshows.sdk.core.client.tempalte.single.apienum.SingleApiDefinitionEnum;
import com.fshows.sdk.core.client.tempalte.single.request.SingleBaseRequest;
import com.fshows.sdk.core.client.tempalte.single.response.SingleBaseResponse;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.RequestParamUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTemplateApiClinet
extends AbstractApiClient<SingleBaseRequest, SingleBaseResponse, SingleApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(SingleTemplateApiClinet.class);
    protected IApiSignHandler iApiSignHandler = new RsaSignHandlerImpl();
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();

    public SingleTemplateApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

    @Override
    public SingleBaseResponse execute(SingleBaseRequest request, SingleApiDefinitionEnum apiDefinition) throws FsApiException {
        return (SingleBaseResponse)super.doExecute(request, apiDefinition);
    }

    @Override
    public SingleBaseResponse execute(SingleBaseRequest request, SingleApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return (SingleBaseResponse)super.doExecute(request, apiDefinition, configModel);
    }

    @Override
    protected ApiRequestModel buildApiRequestModel(SingleBaseRequest request, DefaultRequestContext context) {
        DefaultClientConfigModel defaultClientConfigModel = context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
        apiRequestModel.setParamMap(RequestParamUtils.toMapObj(request, this.apiClientConfig.isHump(), true));
        apiRequestModel.setRequestSign(this.iApiSignHandler.sign(apiRequestModel, context));
        SingleBaseRequest singleBaseRequest = new SingleBaseRequest();
        singleBaseRequest.setMchntCd(defaultClientConfigModel.getAppId());
        singleBaseRequest.setSignature(apiRequestModel.getRequestSign());
        apiRequestModel.setRequest(singleBaseRequest);
        String requestBody = this.paramSerializable.serializeObject(apiRequestModel, context);
        apiRequestModel.setRequestBody(requestBody);
        return apiRequestModel;
    }

    @Override
    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("fuiou-sdk");
        clientInfoModel.setClientCode("\u5bcc\u53cb\u5206\u8d26");
        return clientInfoModel;
    }

    @Override
    protected SingleBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        DefaultClientConfigModel clientConfigModel = requestContext.getApiClientConfig();
        apiResponseModel.setResponse(this.paramSerializable.deserializationResponse(apiResponseModel, apiRequestModel, requestContext));
        Boolean verifySign = this.iApiSignHandler.verifySign(apiResponseModel, apiRequestModel, requestContext);
        if (clientConfigModel.isVrifySignResponse() && !Boolean.TRUE.equals(verifySign)) {
            throw new FsApiException("\u9a8c\u7b7e\u5931\u8d25");
        }
        return (SingleBaseResponse)apiResponseModel.getResponse();
    }

    @Override
    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }
}

