/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.response.FubeiPayBizResponse;
import com.frt.fubeiopenapisdk.response.trade.detail.FubeiPayAlipayExtendResponse;
import com.frt.fubeiopenapisdk.response.trade.detail.FubeiPayOrderCouponResponse;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author yangdw
 * @version ScanCardResult.java, v 0.1 2019-11-11 14:07
 */
@Data
public class FubeiPayScanCardResponse extends FubeiPayBizResponse {

    private static final long serialVersionUID = 1889161719858691450L;
    /**
     * 外部系统订单号
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;

    /**
     * 付呗订单号
     */
    @JSONField(name = "order_sn")
    private String orderSn;

    /**
     * 机构订单号，支付成功时返回
     */
    @JSONField(name = "ins_order_sn")
    private String insOrderSn;

    /**
     * 	通道订单号，微信订单号、支付宝订单号等，支付成功时返回
     */
    @JSONField(name = "channel_order_sn")
    private String channelOrderSn;

    /**
     * 付呗商户号
     */
    @JSONField(name = "merchant_id")
    private Integer merchantId;


    /**
     *订单状态：
     * USERPAYING--用户支付中
     * SUCCESS--支付成功
     */
    @JSONField(name = "order_status")
    private String orderStatus;

    /**
     * 支付方式
     */
    @JSONField(name = "pay_type")
    private String payType;

    /**
     * 订单金额
     */
    @JSONField(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 实收金额，当交易成功时才返回
     */
    @JSONField(name = "net_amount")
    private BigDecimal netAmount;

    /**
     * 买家实际支付金额
     */
    @JSONField(name = "buyer_pay_amount")
    private BigDecimal buyerPayAmount;

    /**
     * 手续费（直连没有手续费返回）
     */
    @JSONField(name = "fee")
    private BigDecimal fee;

    /**
     * 商户门店号
     */
    @JSONField(name = "store_id")
    private Integer storeId;

    /**
     * 付款用户id，“微信openid”、“支付宝账户”等
     */
    @JSONField(name = "user_id")
    private String userId;

    /**
     * 支付完成时间，格式为yyyyMMddHHmmss
     */
    @JSONField(name = "finish_time")
    private String finishTime;

    /**
     * 终端号
     */
    @JSONField(name = "device_no")
    private String deviceNo;

    /**
     * 	附加数据,原样返回
     */
    @JSONField(name = "attach")
    private String attach;

    /**
     * 活动优惠列表
     */
    @JSONField(name = "payment_list")
    private List<FubeiPayOrderCouponResponse> paymentList;

    /**
     * 花呗分期返回
     */
    @JSONField(name = "alipay_extend_params")
    private FubeiPayAlipayExtendResponse alipayExtendParams;

    /**
     * 收银员id
     */
    @JSONField(name = "cashier_id")
    private Integer cashierId;
}