package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;


@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantQueryResponse extends FubeiBizResponse {

    /**
     * 付呗商户ID
     */
    private Integer merchantId;
    /**
     * 商户账号，外部系统的唯一商户编号（可以用作登录付呗商户后台）
     */
    private String merchantCode;
    /**
     * 进件状态 REJECTED(驳回)、AUDITING（审核中）、PASSED（通过）
     */
    private String incomeStatus;
    /**
     * 拒绝原因
     */
    private String refusalReason;
    /**
     * 签约地址
     */
    private String contractUrl;

    /**
     * 商户入驻状态:
     * 未入驻：在对应的入驻通道侧没有成功进件过(UN_INCOME)
     * 已入驻：在对应的入驻通道侧有成功进件过至少一次(INCOME)
     */
    private String merchantStatus;
    /**
     * 签约状态
     * UNSIGNED：未签约
     * INVALID：失效
     * SIGNED：已签约
     * CANCEL：签约终止
     * NO_NEED:无需签约
     */
    private String signStatus;
    /**
     * 协议类型
     * 进件状态为UNSIGNED时返回LICENSE入网协议
     * CERTIFICATE非法人结算授权
     */
    private String protocolType;
    /**
     * 协议签约类型为非法人授权协议时返回除富友电子签外or无需签约，不返回该值
     * 0：短信认证
     * 1：链接认证
     */
    private Integer signCheckType;

    /**
     * 协议链接二维码
     */
    private String contractPicUrl;
}
