package com.frt.fubeiopenapisdk.request.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

@Data
public class FubeiPayTerminalInfoRequest {

    /**
     * 经度，+代表东经，-代表西经，可获取时上传
     */
    @JSONField(name = "longitude")
    private String longitude;
    /**
     * 纬度，+代表北纬，-代表南纬，可获取时上传
     */
    @JSONField(name = "latitude")
    private String latitude;
    /**
     * 终端交易IP，可获取时上传
     */
    @JSONField(name = "device_ip")
    private String deviceIp;
    /**
     * 银行卡受理终端入网编号设备类型02、 03、04、05、06、08、09 、 10时必选 格式：5 位字符示例：例如 P3100，参考银联UPTS证书，认证编号
     */
    @JSONField(name = "network_license")
    private String networkLicense;
    /**
     * 设备类型
     */
    @JSONField(name = "device_type")
    private String deviceType;
    /**
     * 设备序列号设备类型02、 03、04、05、06、08、09 、 10时必选，且传TUSN；其他设备类型时该字段传设备序列号（如：收银机编号）
     */
    @JSONField(name = "serial_num")
    private String serialNum;
    /**
     * 加密随机因子
     */
    @JSONField(name = "encrypt_rand_num")
    private String encryptRandNum;
    /**
     * 密文数据,设备类型02、 03、04、05、06、08、09 、 10时必选 格式：5 位字符,64bit的密文数据，对终端硬件序列号和加密 随机因子加密后的结果。 本子域取值为：64bit 密文数据进行 base64 编码后的结果注：该方式可咨询设备厂家。该流程为银联标准流程基本和银行卡交易一致，使用设备21号文密钥对终端硬件序列号和随机因子加密，得到8字节数据，然后进行base64运算
     */
    @JSONField(name = "secret_text")
    private String secretText;
    /**
     * 固定8位，右补空格，终端应用程序的版本号
     */
    @JSONField(name = "app_version")
    private String appVersion;
    /**
     * 通道终端编号固定8位可获取时上送
     */
    @JSONField(name = "device_id")
    private String deviceId;
}