/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhoujp
 * @version AlipayExtendParams.java, v 0.1 2020-01-03 15:24 zhoujp
 */
@Data
public class FubeiPayAlipayExtendRequest {

    /**
     * 分期类型
     * 0-不使用分期
     * 1-使用花呗分期
     * 2-使用信用卡分期
     */
    @JSONField(name = "hb_fq_instalment")
    private Integer hbFqInstalment;
    /**
     * 花呗分期期数
     */
    @JSONField(name = "hb_fq_num")
    private Integer hbFqNum;

    /**
     * 手续费承担模式
     * 默认为0（消费者承担）。0=消费者承担；100=商户承担（间联通道暂不支持商户承担，故该参数当前无效）
     */
    @JSONField(name = "hb_fq_seller_percent")
    private Integer hbFqSellerPercent;

    /**
     * 前置咨询流水ID(花呗分期免息/立减权益)
     * 为保证单通道2.0场景下，收单维度知道这是一笔来自前置咨询且代表单通道2.0的交易
     */
    @JSONField(name = "pre_consult_id")
    private String preConsultId;

    /**
     * 消费者选择核销权益的运营信息(花呗分期免息/立减权益)
     */
    @JSONField(name = "pay_operation_info_list")
    private List<String> payOperationInfoList;
}