/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.request.FubeiPayBizRequest;
import com.frt.fubeiopenapisdk.request.trade.detail.FubeiPayAlipayExtUserInfoRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 *
 *
 * @author wangyi
 * @version FubeiPayOrderRefundQueryRequest.java, v 0.1 2025-09-08 16:23 wangyi
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiPayOrderWapCreateRequest extends FubeiPayBizRequest {

    /**
     * 商户id
     */
    @JSONField(name = "uid")
    private Integer uid;

    /**
     * 商户id
     */
    @JSONField(name = "merchant_id")
    private Integer merchantId;

    /**
     * 第三方订单号(开放平台必传)
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;
    /**
     * 门店id
     */
    @JSONField(name = "store_id")
    private Integer storeId;

    /**
     * 收银员id
     */
    @JSONField(name = "cashier_id")
    private Integer cashierId;
    /**
     * 订单总金额，单位为元
     */
    @NotNull(message = "不能为空")
    @DecimalMax(value = "10000000",message = "订单金额超过上限")
    @DecimalMin(value = "0.01",message = "订单金额低于下限")
    private BigDecimal totalAmount;

    /**
     * 商品描述
     */
    @Length(max = 128,message = "不符合规范")
    @JSONField(name = "body")
    private String body;

    /**
     * 不参与优惠金额
     */
    @Digits(integer = 9, fraction = 2)
    @DecimalMax(value = "100000000",message = "优惠金额超过上限")
    @DecimalMin(value = "0",message = "优惠金额低于下限")
    @JSONField(name = "additional_price")
    private BigDecimal additionalPrice = BigDecimal.ZERO;

    /**
     * 折扣开关 1开启 0关闭
     */
    @JSONField(name = "discount_switch")
    private Integer discountSwitch;

    /**
     * 支付回调地址
     */
    @Length(max = 255,message = "不符合规范")
    @JSONField(name = "notify_url")
    private String notifyUrl;

    /**
     * 设备号
     */
    @JSONField(name = "device_no")
    private String deviceNo;

    /**
     * 备注
     */
    @JSONField(name = "remark")
    private String remark;

    /**
     * 用户付款中途退出返回商户网站的地址
     */
    @JSONField(name = "quit_url")
    private String quitUrl;

    /**
     * 附加数据
     * 该字段主要用于商户携带订单的自定义数据
     */
    @JSONField(name = "attach")
    private String attach;

    /**
     * 交易超时时间
     * 第三方商户可自定义的交易超时时间，超出此时间，订单将会关闭，不允许支付
     */
    @JSONField(name = "timeout_express")
    private String timeoutExpress;

    /**
     * 请求类型；GET-get方式   POST-post方式
     */
    @JSONField(name = "request_type")
    private String requestType;

    /**
     * 支付成功后跳转的url
     */
    @JSONField(name = "return_url")
    private String returnUrl;

    /**
     * 花呗分期期数
     */
    @JSONField(name = "hb_fq_num")
    private Integer hbFqNum;

    /**
     * type 1WAP,2APP,3刷卡,4扫码(3、4属于商户版),5公共号会员卡充值,12H5支付.
     * 非必填  默认wap
     */
    @JSONField(name = "type")
    private Integer type;

    /**
     * 消费者的真实网络IP地址
     * 必须上传正确的用户端 外网Ip，支持 ipv4/ipv6 格式。
     * 商户在获取创单IP时，不要去获取用户请求的HTTP头中而是直接获取当前跟自己建立连接的IP地址(从前端获取)
     */
    @NotBlank(message = "不能为空")
    @JSONField(name = "user_ip")
    private String userIp;

    /**
     * 买家支付宝用户id
     */
    @JSONField(name = "buyer_id")
    private String buyerId;

    /**
     * 买家支付宝用户唯一标识
     */
    @JSONField(name = "buyer_open_id")
    private String buyerOpenId;

    /**
     * 小程序支付中，商户实际经营主体的小程序应用的appid，也即最终唤起收银台支付所在的小程序的应用id
     * 【注意事项】商户需要先在产品管理中心绑定该小程序appid，否则下单会失败
     */
    @JSONField(name = "op_app_id")
    private String opAppId;

    /**
     * 买家支付宝用户唯一标识（商户实际经营主体的小程序应用关联的买家open_id）
     */
    @JSONField(name = "op_buyer_open_id")
    private String opBuyerOpenId;

    /**
     * 指定外部买家信息
     */
    @JSONField(name = "ext_user_info")
    private FubeiPayAlipayExtUserInfoRequest extUserInfo;

    /**
     * 指定支付渠道。 用户只能使用指定的渠道进行支付，多个渠道以逗号分割。
     */
    @JSONField(name = "enable_pay_channels")
    private String enablePayChannels;

    /**
     * 禁用渠道,用户不可用指定渠道支付，多个渠道以逗号分割。
     */
    @JSONField(name = "disable_pay_channels")
    private String disablePayChannels;

    /**
     * 指定单通道。
     */
    @JSONField(name = "specified_channel")
    private String specifiedChannel;

    /**
     * 是否b2b
     */
    @JSONField(name = "alipay_b2b")
    private Boolean alipayB2b = Boolean.FALSE;
}