/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zhoujp
 * @version WechatAuthContactInfoParm.java, v 0.1 2020-12-22 14:57 zhoujp
 */
@Data
public class WechatAuthContactInfoRequest implements Serializable {
    private static final long serialVersionUID = 265911153292236144L;

    /**
     * 联系人类型
     * 1：经营者/法人
     * 2：经办人
     */
    @NotNull(message = "不能为空")
    @Min(value = 1, message = "不符合规范")
    @Max(value = 2, message = "不符合规范")
    private Integer contactType;

    /**
     * 联系人姓名
     */
    @NotBlank(message = "不能为空")
    private String name;
    /**
     * 联系人手机号
     */
    @NotBlank(message = "不能为空")
    private String mobile;
    /**
     * 联系人身份证号码
     */
    @NotBlank(message = "不能为空")
    private String idCardNumber;

    /**
     * 联系人证件类型
     * IDENTIFICATION_TYPE_IDCARD-身份证（限中国大陆居民)
     * IDENTIFICATION_TYPE_OVERSEA_PASSPORT-护照（限境外人士)
     * IDENTIFICATION_TYPE_HONGKONG_PASSPORT-中国香港居民-来往内地通行证
     * IDENTIFICATION_TYPE_MACAO_PASSPORT-中国澳门居民-来往内地通行证
     * IDENTIFICATION_TYPE_TAIWAN_PASSPORT-中国台湾居民-来往大陆通行证
     * IDENTIFICATION_TYPE_FOREIGN_RESIDENT-外国人居留证
     * IDENTIFICATION_TYPE_HONGKONG_MACAO_RESIDENT-港澳居民证
     * IDENTIFICATION_TYPE_TAIWAN_RESIDENT-台湾居民证
     * IDENTIFICATION_TYPE_OTHER-其他
     */
    private String contactIdDocType;

    /**
     * 联系人证件正面照片
     */
    private String contactIdDocCopy;

    /**
     * 联系人证件反面照片
     */
    private String contactIdDocCopyBack;

    /**
     * 联系人证件有效期开始时间
     */
    private String contactPeriodBegin;

    /**
     * 联系人证件有效期结束时间
     */
    private String contactPeriodEnd;

    /**
     * 联系人证件有效期是否长期有效：
     * 0-否,1-是
     */
    private Integer contactPeriodIsLong;

    /**
     * 业务办理授权函
     */
    private String businessAuthorizationLetter;
}