/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;

/**
 * @author weikunpeng
 * @version SignInfoParam.java, v 0.1 2025-09-26 17:32 weikunpeng
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class SignInfoRequest implements Serializable {
    /**
     * 签约方式
     * 0-纸质签约
     * 1-电子签
     */
    private Integer signType;

    /**
     * 签约人角色
     * 0-法人
     * 1-经办人
     */
    private Integer signPersonType;

    /**
     * 签约验证方式
     * 0-短信验证
     * 1-链接验证
     */
    private Integer signCheckType;

    /**
     * 法人签约手机号
     */
    private String signLegalMobile;

    /**
     * 经办人证件类型
     * 1-身份证(默认)
     * 2-香港通行证(回乡证)
     * 3-台湾身份证
     * 4-香港身份证
     * 5-澳门身份证
     * 6-护照
     * 7-居住证
     * 9-其它法定文件
     * 10-台湾通行证(台胞证)
     * 11-澳门通行证(回乡证)
     * 12-临时身份证
     */
    private Integer operatorIdentityType;

    /**
     * 经办人身份证人像面照片
     */
    private String operatorIdCardFrontPic;

    /**
     * 经办人身份证号码
     */
    private String operatorIdCardNo;

    /**
     * 经办人身份证姓名
     */
    private String operatorIdCardName;

    /**
     * 经办人签约手机号
     */
    private String operatorSignMobile;

    /**
     * 经办人委托授权书
     */
    private String operatorSignPowerAttorneyPic;

}