/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author xujw
 * @version AlipayMerchantAuthMerchantInfo.java, v 0.1 2023-01-06 16:43
 */
@Data
public class AlipayMerchantAuthMerchantInfo implements Serializable {
    private static final long serialVersionUID = -6250380505031767309L;

    /**
     * 小微商户类型；商户类型为小微时必填1：固定门店场所2：流动经营/便民服务 商户类型为小微时必填
     */
    private Integer merchantType;
    /**
     * 门店经营地址；流动经营/便民服务无需上传 商户类型为小微且固定门店场所时可上传如不上传则默认取进件资料
     */
    private String storeAddress;
    /**
     * 门头照/摊位照片 请先使用图片上传上传，上传成功后填写对应的资源id 商户类型为小微时可上传，如如不上传则默认取进件照片
     */
    private String storeDoor;
    /**
     * 店内环境照/摊位侧面照片 请先使用图片上传上传，上传成功后填写对应的资源id 商户类型为小微时可上传，如不上传则默认取进件照片
     */
    private String storeInnr;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}    