/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author xujw
 * @version AlipayMerchantAuthInstitution.java, v 0.1 2023-01-06 16:44
 */
@Data
public class AlipayMerchantAuthInstitution implements Serializable {
    private static final long serialVersionUID = -3667107904083642671L;

    /**
     * 证书类型（事业单位、其他组织 必填）1：社会团体法人登记证书2：民办非企业单位登记证书3：基金会法人登记证书4：农村集体经济组织登记证书5：宗教活动场所登记证书6：其他证书/批文/证明﹂certificate_photo	String	是		证书照片请先使用图片上传上传，上传成功后填写对应的资源id
     */
    private Integer certificateType;
    /**
     * 证书照片 请先使用图片上传上传，上传成功后填写对应的资源id
     */
    private String certificatePhoto;
    /**
     * 证书编号
     */
    private String certificateNo;
    /**
     * 注册地址示例值：浙江省杭州市余杭区良渚街道洋帆中心
     */
    private String certificateAddress;
    /**
     * 请上传证件有效期开始时间示例值：2019-06-06
     */
    private String certificateBegin;
    /**
     * 请按照示例值填写，若证件有效期为长期，请填写：长期。示例值：2026-06-06 or 长期
     */
    private String certificateEnd;
    /**
     * 证书有效期是否长期有效0-否1-是
     */
    private Integer certificateLong;
    /**
     * 单位证明函 ； 证明函下载 请先使用图片上传上传，上传成功后填写对应的资源id 证明函的信息需要全部打印，不支持手写商户信息，最后加盖公章。
     */
    private String authorizationPhoto;


    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}    