package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.AccountInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.AddressInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.BaseInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.ContactInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.LegalPersonRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.LicenseInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.OtherInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.RateInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.ShopInfoRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;

/**
 * 付呗批量进件
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantRateRequest extends FubeiBizRequest {

    /**
     * 商户号
     */
    @Min(value = Integer.MIN_VALUE, message = "不符合规范")
    @Max(value = Integer.MAX_VALUE, message = "不符合规范")
    private Integer merchantId;

    /**
     * 自定义商户号
     */
    @Length(max = 60, message = "不符合规范")
    private String merchantCode;

    /**
     * 支付宝分佣率
     * 代理商支付宝分佣率（0-10之间，单位为千分之一）
     */
    @Length(max = 6, message = "不符合规范")
    private String alipayFeeRate;

    /**
     * 微信分佣率
     * 代理商微信分佣率（0-10之间，单位为千分之一）
     */
    @Length(max = 6, message = "不符合规范")
    private String wxFeeRateFloat;

    /**
     * 银联分佣率
     * 代理商银联分佣率（0-10之间，单位为千分之一）
     */
    @Length(max = 6, message = "不符合规范")
    private String unionFeeRateFloat;

    /**
     * 银联>1000分佣率
     * 代理商银联分佣率（0-10之间，单位为千分之一）
     */
    @Length(max = 6, message = "不符合规范")
    private String union2Fee;

    /**
     * 银联>1000借记卡封顶手续费
     */
    @Pattern(regexp = "[1-9]\\d*", message = "封顶手续费只能为整数")
    private String debitUnion2AppedFee;
    /**
     * 云闪付>1000贷记卡费率
     */
    @Length(max = 6, message = "不符合规范")
    private String union2CreditFee;

    /**
     * 商户贷记卡（信用卡）费率
     * 千分之 5.2 ~ 50 保留俩位小数
     */
    private String creditCardFee;
    /**
     * 商户借记卡费率
     * 千分之 4.2 ~ 50 保留俩位小数
     */
    private String debitCardFee;

    /**
     * 商户借记卡封顶手续费（默认18元） 最大不能超过500元
     */
    @Pattern(regexp = "[1-9]\\d*", message = "封顶手续费只能为整数")
    private String debitCardAppedFee;

    /**
     * 预付款费率
     * 目前只支持万达的商户
     * 默认 1%  百1 即入参传10
     */
    private String prepayCardFee;

    /**
     * 支付宝云资通商户终端费率（‰），范围：6.1~100
     */
    private String alipayYztRate;

    /**
     * 数币费率
     */
    private String dcepFee;

    /**
     * D0提现费率
     */
    private String d0WithdrawRate;
}
