package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 付呗批量进件
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantRateQueryRequest extends FubeiBizRequest {
    /**
     * 商户号
     */
    @Min(value = Integer.MIN_VALUE, message = "不符合规范")
    @Max(value = Integer.MAX_VALUE, message = "不符合规范")
    private Integer merchantId;

    /**
     * 自定义商户号
     */
    @Length(max = 60, message = "不符合规范")
    private String merchantCode;

    /**
     * 目标费率类型 2-商户生效费率查询 3-商户最新费率查询
     */
    @NotNull(message = "不能为空")
    @Min(value = 2, message = "不符合规范")
    @Max(value = 3, message = "不符合规范")
    private Integer targetRateType;
}
