/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.AlipayMerchantAuthContactInfo;
import com.frt.fubeiopenapisdk.request.merchant.detail.AlipayMerchantAuthInstitution;
import com.frt.fubeiopenapisdk.request.merchant.detail.AlipayMerchantAuthLegalInfo;
import com.frt.fubeiopenapisdk.request.merchant.detail.AlipayMerchantAuthMerchantInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhoujp
 * @version WechatAuthParam.java, v 0.1 2020-12-22 14:55 zhoujp
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
@EqualsAndHashCode(callSuper = true)
public class FubeiMerchantAlipayAuthApplyRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -4790483516033294982L;

    /**
     * 付呗商户号，以服务商级接入时必传；以商户级接入时不传；
     */
    private Integer merchantId;
    /**
     * 商户门店号
     */
    private Integer storeId;
    /**
     * 业务申请编号,由第三方自定义
     */
    private String businessCode;
    /**
     * 法人证件居住地址 1、商户类型为企业时，该字段必填。2、其他主体类型，无需填写。
     */
    private String identificationAddress;
    /**
     * 商户主体类型1：个体商户2：企业商户3：小微商户4：事业单位5：其他组织 不上传则默认取进件资料
     */
    private Integer identityType;

    /**
     * 联系人信息，联系人是商户的超级管理员，将接收开户信息及日常重要管理信息，请确定超级管理员为商户法定代表人或负责人再进行操作。如超级管理员非商户法定代表人或负责人，请联系法定代表人或负责人提交申请。若不上传，默认取开户时候填写的法人信息 若进件时未非身份证类型法人，请务必上传
     */
    private AlipayMerchantAuthContactInfo contactInfo;
    /**
     * 法人信息 不上传则默认取进件资料
     */
    private AlipayMerchantAuthLegalInfo legalInfo;
    /**
     * 商户类型为小微时必填
     */
    private AlipayMerchantAuthMerchantInfo merchantInfo;
    /**
     * 商户主体类型为 事业单位、其他组织 的时候必填
     */
    private AlipayMerchantAuthInstitution institution;

}