/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import javax.validation.constraints.Digits;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author mj
 * @version SubAccountMemberAddRuleListParam.java, v 0.1 2019-11-06 14:09 mj
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class SubAccountMemberAddRuleListRequest implements Serializable {
    private static final long serialVersionUID = -4898476560510521458L;
    /**
     * 门店id
     */
    private String storeId;

    /**
     * 分账比例，精度0.00001
     */
    @Digits(integer = 2, fraction = 5)
    private BigDecimal shareScale;
}