package com.frt.fubeiopenapisdk.apienum;

import com.frt.fubeiopenapisdk.request.trade.FubeiPayH5PayOrderRequest;
import com.frt.fubeiopenapisdk.request.trade.FubeiPayOrderQueryRequest;
import com.frt.fubeiopenapisdk.request.trade.FubeiPayOrderRefundQueryRequest;
import com.frt.fubeiopenapisdk.request.trade.FubeiPayOrderRefundRequest;
import com.frt.fubeiopenapisdk.request.trade.FubeiPayOrderWapCreateRequest;
import com.frt.fubeiopenapisdk.request.trade.FubeiPayScanCardRequest;
import com.frt.fubeiopenapisdk.response.trade.FubeiPayH5PayOrderResponse;
import com.frt.fubeiopenapisdk.response.trade.FubeiPayOrderQueryResponse;
import com.frt.fubeiopenapisdk.response.trade.FubeiPayOrderRefundQueryResponse;
import com.frt.fubeiopenapisdk.response.trade.FubeiPayOrderRefundResponse;
import com.frt.fubeiopenapisdk.response.trade.FubeiPayOrderWapCreateResponse;
import com.frt.fubeiopenapisdk.response.trade.FubeiPayScanCardResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import lombok.Getter;

@Getter
public enum FubeiPayApiDefinitionEnum implements IApiDefinition {

    /**
     * 订单查询
     */
    ORDER_QUERY(
            "订单查询",
            "fbpay.order.query",
            "1.0.0",
            "",
            FubeiPayOrderQueryRequest.class,
            FubeiPayOrderQueryResponse.class
    ),
    ORDER_PAY(
            "付款码支付",
            "fbpay.order.pay",
            "1.0.0",
            "",
            FubeiPayScanCardRequest.class,
            FubeiPayScanCardResponse.class
    ),
    ORDER_CREATE(
            "统一下单",
            "fbpay.order.create",
            "1.0.0",
            "",
            FubeiPayH5PayOrderRequest.class,
            FubeiPayH5PayOrderResponse.class
    ),
    ORDER_REFUND(
            "订单退款",
            "fbpay.order.refund",
            "1.0.0",
            "",
            FubeiPayOrderRefundRequest.class,
            FubeiPayOrderRefundResponse.class
    ),
    REFUND_QUERY(
            "退款查询",
            "fbpay.order.refund.query",
            "1.0.0",
            "",
            FubeiPayOrderRefundQueryRequest.class,
            FubeiPayOrderRefundQueryResponse.class
    ),
    ALIPAY_WAP_PAY(
            "支付宝wap支付",
            "fbpay.order.wap.create",
            "1.0.0",
            "",
            FubeiPayOrderWapCreateRequest.class,
            FubeiPayOrderWapCreateResponse.class
    ),

    ;

    /**
     * 接口名称
     */
    private final String name;

    /**
     * 交易编码
     */
    private final String trancode;

    /**
     * 接口版本
     */
    private final String version;

    /**
     * 接口类型
     */
    private final String interfaceType;

    /**
     * 请求业务参数的Class类型
     */
    private final Class requestClass;

    /**
     * 响应业务参数的Class类型
     */
    private final Class responseClass;

    FubeiPayApiDefinitionEnum(String name,
                              String trancode,
                              String version,
                              String interfaceType,
                              Class requestClass,
                              Class responseClass) {
        this.name = name;
        this.trancode = trancode;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return trancode;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
