/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.lotterycore.intergration.client.impl;

import com.alibaba.dubbo.config.annotation.Reference;
import com.fshows.fubei.lotterycore.intergration.client.UserPointClient;
import com.fshows.fubei.lotterycore.intergration.client.domain.result.BatchGetUserRandomPointResult;
import com.fshows.fubei.membercore.facade.BenefitsActivityServiceFacade;
import com.fshows.fubei.membercore.facade.domain.response.BenefitsGetResponse;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserPointClientImpl
implements UserPointClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPointClientImpl.class);
    private static final int MAX_RE_RPC_NUM = 3;
    @Reference(version="1.0.0", application="${dubbo.application.id}", timeout=5000)
    private BenefitsActivityServiceFacade benefitsActivityServiceFacade;

    @Override
    public Map<String, BatchGetUserRandomPointResult> randomGetPointBatch(List<String> users) {
        int repeatNum;
        HashMap result = Maps.newHashMap();
        Map<Object, Object> res = Maps.newHashMap();
        for (repeatNum = 0; repeatNum < 3 && null == (res = this.doRpc(users, repeatNum)); ++repeatNum) {
        }
        if (repeatNum >= 3) {
            users.stream().forEach(user -> {
                BatchGetUserRandomPointResult batchGetUserRandomPointResult = new BatchGetUserRandomPointResult();
                batchGetUserRandomPointResult.setPoint(0);
                batchGetUserRandomPointResult.setPointCdk("");
                result.put(user, batchGetUserRandomPointResult);
            });
            return result;
        }
        res.forEach((k, v) -> {
            BatchGetUserRandomPointResult batchGetUserRandomPointResult = new BatchGetUserRandomPointResult();
            if (null == v) {
                result.put(k, batchGetUserRandomPointResult);
            } else {
                if (v.getIntegralNum() != null) {
                    batchGetUserRandomPointResult.setPoint(v.getIntegralNum());
                }
                batchGetUserRandomPointResult.setPointCdk(v.getIntegralBenefitsId());
                result.put(k, batchGetUserRandomPointResult);
            }
        });
        return result;
    }

    private Map<String, BenefitsGetResponse> doRpc(List<String> users, int num) {
        try {
            Map res = Maps.newHashMap();
            res = this.benefitsActivityServiceFacade.batchGetJoinLotteryBenefits(users);
            return res;
        }
        catch (Exception e) {
            LOGGER.error("UserPointClientImpl.BenefitsActivityServiceFacade.batchGetJoinLotteryBenefits rpc error ,repeatNum={},stack={}", (Object)num, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }
}

