/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 *
 * @author liluqing
 * @version SignerUtil.java, v 0.1 2023-12-11 20:35
 */
public class SignerUtil {

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, Object> dataMap, String signKey) {
        StringBuilder waitSignStr = generateWaitSignStr(dataMap, null, true);
        waitSignStr.append("&key=").append(signKey);
        return waitSignStr.toString();
    }

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, Object> dataMap) {
        StringBuilder waitSignStr = generateWaitSignStr(dataMap, null, true);
        return waitSignStr.toString();
    }

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, Object> dataMap, String[] ignoreList, boolean ignoreNull) {
        StringBuilder waitSignStr = generateWaitSignStr(dataMap, ignoreList, ignoreNull);
        return waitSignStr.toString();
    }

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    /*private static StringBuilder generateWaitSignStr(Map<String, Object> dataMap, String[] ignoreList, boolean ignoreNull) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = "";
            if (entry.getValue() != null) {
                value = String.valueOf(entry.getValue());
            }
            if (StringUtils.equals(key, "sign")
                    || StringUtils.equals(key, "signature")
                    || StringUtils.startsWith(key, "reserved")
                    || ArrayUtil.contains(ignoreList, key)) {
                continue;
            }
            if (StrUtil.isBlank(value) && ignoreNull) {
                continue;
            }
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        return sb;
    }*/
    private static StringBuilder generateWaitSignStr(Map<String, Object> dataMap, String[] ignoreList, boolean ignoreNull) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();

            if (StringUtils.equals(key, "sign") ||
                    StringUtils.equals(key, "signature") ||
                    StringUtils.startsWith(key, "reserved") ||
                    ArrayUtil.contains(ignoreList, key)) {
                continue;
            }

            if (value == null) {
                if (ignoreNull) {
                    continue;
                } else {
                    value = "";
                }
            }

            if (value instanceof List) {
                // If the value is a List, convert it to a JSON array string
                List<?> listValue = (List<?>) value;
                StringBuilder jsonArray = new StringBuilder("[");

                for (Object listItem : listValue) {
                    String jsonString = JSON.toJSONString(listItem);
                    Map<String, Object> resultMap = JSON.parseObject(jsonString, new TypeReference<Map<String, Object>>() {});
                    appendJsonArrayItem(jsonArray, resultMap, ignoreList, ignoreNull);
                }

                jsonArray.append("]");
                value = jsonArray.toString();
            }

            appendKeyValue(sb, key, String.valueOf(value));
        }
        return sb;
    }

    private static void appendJsonArrayItem(StringBuilder jsonArray, Map<String, Object> listItemMap, String[] ignoreList, boolean ignoreNull) {
        StringBuilder jsonItem = new StringBuilder("{");

        for (Map.Entry<String, Object> listItemEntry : listItemMap.entrySet()) {
            String listItemKey = listItemEntry.getKey();
            Object listItemValue = listItemEntry.getValue();

            if (ArrayUtil.contains(ignoreList, listItemKey)) {
                continue;
            }

            if (listItemValue == null) {
                if (ignoreNull) {
                    continue;
                } else {
                    listItemValue = "";
                }
            }

            if (jsonItem.length() > 1) {
                jsonItem.append(",");
            }
            jsonItem.append("\"").append(listItemKey).append("\":\"").append(listItemValue).append("\"");
        }

        jsonItem.append("}");
        if (jsonArray.length() > 1) {
            jsonArray.append(",");
        }
        jsonArray.append(jsonItem);
    }



    private static void appendKeyValue(StringBuilder sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(key).append("=").append(value);
    }
}