/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base.model;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;

import java.util.Map;

/**
 * http请求数据
 *
 * @author liluqing
 * @version HttpRequestModel.java, v 0.1 2023-12-11 19:45
 */
@Data
public class ApiRequestModel {

    /**
     * 接口url
     */
    private String apiURL;

    /**
     * http请求头
     */
    private Map<String, String> headMap;

    /**
     * 请求业务参数
     */
    private Map<String, Object> paramMap;

    /**
     * 请求入参
     */
    private IRequestDefinition request;

    /**
     * 请求签名
     */
    private String requestSign;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * http请求正文
     */
    private String requestBody;

    /**
     * form表单提交的参数, form表单提交时需要该参数
     */
    private Map<String, String> requestForm;
}