/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.component.serializable;

import com.alibaba.fastjson.JSONObject;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;

/**
 * json序列化器
 *
 * @author liluqing
 * @version JsonSerializable.java, v 0.1 2023-12-13 16:19
 */
public class JsonSerializableHandler implements ISerializableHandler {
    @Override
    public String serializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        return JSONObject.toJSONString(apiRequestModel.getRequest());
    }

    @Override
    public IResponseDefinition deserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        return JSONObject.parseObject(apiResponseModel.getResponseBody(), requestContext.getIApiDefinition().getResponseClass());
    }
}